// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Procedures for freshing a packed file.
//.......................................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include <shellapi.h>
#include <shlobj.h>
#include "Tscmsg.h"
#include "Check.h"
#include "zlib.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	DWORD				dwStringSafeFlag;
extern	HINSTANCE			hInst;
extern	LPTSTR				lpszNA;
extern	HWND				hMainWindow;
extern	LPCTSTR				lpszAppName;
extern	LPCTSTR				lpIconPointer;
extern	HWND				hDialogModeLess;
extern	HWND				hDlgCurrent;
extern	BOOL				bProcessInProgress;
extern	BOOL				bCancelOperation;
extern	LPBYTE				lpFileName;
extern	LPBYTE				lpFileExtension;
extern	HICON				hIcon;
extern	HICON				hIcon2;
extern	int					iWhichAviClip;
extern	int					iStepIncrement;
extern	BOOL				bAviClipOK;
extern	HWND				hAviClip;
extern	TCHAR				szFileName[MAX_PATH];
extern	HANDLE				hInputFile;
extern	int					iNumberOfFiles;
extern	LPBYTE				lpCrc32Table;
extern	NUMBERFMT			nFormatInfo;
extern	PACKED_FILE_HEADER	pfhdr;
extern	PACKED_FILE_ID_HDR	pfidhdr;
extern	BYTE				PackedFileId[4];
extern	BYTE				PackedFileId1[4];
extern	MEMORYSTATUS		mst;
extern	DWORD				dwCheckCrc32;
extern	DWORD				dwPassCrc32;
extern	LPBYTE				lpInBuffer;
extern	LPBYTE				lpOutBuffer;
extern	HICON				hIcon2;
extern	LPBYTE				lpCodeTable;
extern	LPBYTE				lpHashTable;
extern	DWORD				dwHashTableSize;
extern	CODE_STATS			CodeStats;
extern	DWORD				dwCodeTableSize;
extern	DWORD				dwPStackSize;
extern	TCHAR				szDestination[MAX_PATH];
extern	LPBYTE				lpDestinationFileName;
extern	LPBYTE				lpDestExtension;
extern	TCHAR				szBackUpFile[MAX_PATH];
extern	HANDLE				hBackUpFile;
extern	int					iMaxPack;
extern	LPBYTE				lpAppendPtr;
extern	LPBYTE				lpAppendExt;
extern	ULARGE_INTEGER		uliTotalCodes;
extern	ULARGE_INTEGER		uliInCount;
extern	ULARGE_INTEGER		uliFileCodes;
extern	ULARGE_INTEGER		uliOutCount;
extern	ULARGE_INTEGER		uliFileOut;
extern	ULARGE_INTEGER		uliFileIn;
extern	ULARGE_INTEGER		uliFinalFileSize;
extern	LARGE_INTEGER		liHalfPercent;
extern	LARGE_INTEGER		liHalfPercentDup;
extern	SHFILEINFO			shfi1;
extern	BOOL				bWipeAfterPacking;
extern	OPENFILENAME		ofnPack;
extern	BOOL				bWipeFiles;
extern	BOOL				bUseNew;
extern	BOOL				bWeHaveLzw;
extern	HFONT				hDlgFont;
extern	BOOL				bWin2000OrGreater;

// Variables used by the freshen a packed file procedure.
//.......................................................
TCHAR				szFreshResults[] = "%u out of %d files in the packed file were freshened.";

// Packed file directory structure pointer.
//.........................................
LPPACKED_FILE_DIR		lppfd;

// Add files to a packed file.
//............................
VOID AddFilesToAPackedFile()
{
	WIN32_FIND_DATA				wfd;
	ULARGE_INTEGER				uliFreeCallerBytes;
	ULARGE_INTEGER				uliTotalBytes;
	ULARGE_INTEGER				uliHdr;
	ULARGE_INTEGER				uli;
	ULARGE_INTEGER				uliScratch1;
	OPENFILENAME				ofn;
	LPPACKED_FILE_DIR			lppDir;
	BY_HANDLE_FILE_INFORMATION	fi;
	LPBYTE						lpFileReturn = 0;
	LPBYTE						lpTempFilePtr;
	LPBYTE						lpFileInsert;
	LPBYTE						lpTransferFile;
	BOOL						bResult;
	HANDLE						hSearch;
	HANDLE						hTransferFile;
	DWORD						dwOldHelpTopic;
	DWORD						dwBytesRead;
	DWORD						dwBytesToRead;
	DWORD						dwBytesWritten;
	DWORD						dwHeaderSize;
	int							iFileNameLength;
	int							iTotalFiles;
	int							iResult;
	int							iFilesToProcess;
	int							iFilesInDir;
	UINT						uiDriveType;
	int							iFilesToAdd;
	BOOL						bDiskError;
	BOOL						bMoreThanOne;
	HANDLE						hTempFile = 0;
	HANDLE						hDestination = 0;
	TCHAR						szTempFile[MAX_PATH];
	TCHAR						szRoot[16];
	
	bProcessInProgress = TRUE;
	dwOldHelpTopic = ChangeHelpTopic(IDH_ADD);
	bAviClipOK = FALSE;
	bDiskError = TRUE;
	bWipeAfterPacking = FALSE;
	dwHeaderSize = sizeof(PACKED_FILE_DIR);

	// Setup a temporary file for packing.
	//....................................
	GetTempPath(MAX_PATH,(LPTSTR)&szTempFile);
	GetTempFileName((LPTSTR)&szTempFile,TEXT("pkd"),0,(LPTSTR)&szTempFile);
	bResult = DeleteMyFile((LPTSTR)&szTempFile);
	if (!bResult)
	{
		goto AddEnd;
	}
	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_SOURCE);

	// Initialize with specific information for this procedure.
	//.........................................................
	ofn.lpstrFile = szFileName;
	ofn.nMaxFile = sizeof(szFileName);
	ofn.hwndOwner = hMainWindow;
	ofn.lpstrFilter = TEXT("Packed Files [.pkd]\0*.pkd\0All Files [*.*]\0*.*\0");
	ofn.nFilterIndex = 1;
	ofn.lpstrTitle = TEXT("Select a Packed File to Add Files To");
	ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
		         OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_SHOWHELP | 
				 OFN_HIDEREADONLY);
	ofn.lpstrDefExt = NULL;
	ofn.lpfnHook = MyOFNHookProc;

	// Setup the icon to use in the caption bar.
	//..........................................
	lpIconPointer = lpszAppName;

	while(TRUE)
	{
		ZeroMemory(&szFileName,sizeof(szFileName));

		// Select the packed file to add files to.
		//........................................
		if (!GetOpenFileName(&ofn))
		{
			CommDlgBoxErrorProc(IDS_GET_FILES);
			goto AddEnd;
		}
		SaveDirName((LPBYTE)&szFileName,SAVE_SOURCE,TRUE);

		// Make sure the file is a valid packed file.
		//...........................................
		lpFileName = PathFindFileName((LPCTSTR)&szFileName);
		lpFileExtension = PathFindExtension((LPCTSTR)&szFileName);

		hInputFile = IsValidPackedFile((LPBYTE)&szFileName,TRUE);

		if (hInputFile)
		{
			// See if we have any free disk space. cd rom drives that
			// are not writable will report zero. Use szDestinaiton
			// to setup a directory name.
			//.......................................................
			CopyMemory(&szDestination,&szFileName,sizeof(szFileName));
			PathRemoveFileSpec((LPTSTR)&szDestination);
			ZeroMemory(&szRoot,sizeof(szRoot));
			CopyMemory(&szRoot,&szDestination,3);
			bResult = GetDiskFreeSpaceEx((LPCTSTR)&szRoot,
										(PULARGE_INTEGER)&uliFreeCallerBytes.QuadPart,
										(PULARGE_INTEGER)&uliTotalBytes.QuadPart,NULL);
			if (!bResult)
			{
				ErrorProcedure((LPTSTR)&szDestination,IDS_GETFREEDSKSPACE,MB_OK);
				goto AddEnd;
			}
			if (uliFreeCallerBytes.QuadPart == 0)
			{
				SetLastError(IDS_NOSPACEFRESHEN);
				ErrorProcedure((LPTSTR)&szFileName,IDS_GETFREEDSKSPACE,MB_OK);

				// Close the file and try again.
				//..............................
				goto TryAgain;
			}
			break;
		}
		// We do not have a valid packed file.
		//....................................
		SetLastError(IDS_INVALIDPACKEDFILE);
		ErrorProcedure((LPTSTR)&szFileName,IDS_READ,MB_OK);
	
		// Close the file and try again.
		//..............................
	  TryAgain:
		bResult = CloseMyHandle((LPTSTR)&szFileName,hInputFile);
		if (!bResult)
		{
			goto AddEnd;
		}
		hInputFile = 0;
	}
	EmptyTheMessageQue();

	// Allocate the memory for the return file buffer. This is
	// the maximum sized buffer that the GetOpenFileName common
	// dialog box procedure can handle.
	//.........................................................
	lpFileReturn = AllocateMemory((64 * 1024) - 1);
	if (!lpFileReturn)
	{
		goto AddEnd;
	}
	// Initialize with specific information for this procedure.
	//.........................................................
	ofn.lpstrFile = lpFileReturn;
	ofn.nMaxFile = ((64 * 1024) - 1);
	ofn.hwndOwner = hMainWindow;
	ofn.hInstance = hInst;
	ofn.lpstrFilter = TEXT("All Files [*.*]\0*.*\0Tscg Files [.rng;.rsakey;.tsc;.otp;.pad;.tsig;.jrl]\0*.rng;*.rsakey;*.tsc;*.otp;*.pad;*.tsig;*.jrl\0Compressed Files [.pkd;.lha;.zip;.arj;.cab]\0*.pkd;*.lha;*.zip;*.arj;*.cab\0Adobe PDF Files [.pdf]\0*.pdf\0Executable Files [.exe;.dll;.ocx]\0*.exe;*.dll;*.ocx\0Image Files [.bmp;.dib;.gif;.jpg;,ico;,cur]\0*.bmp;*.dib;*.gif;*.jpg;*.ico;*.cur\0Word Documents [.doc]\0*.doc\0Web Pages [.htm;.html;.mht]\0*.htm;*.html;*.mht\0Email Files [.eml]\0*.eml\0Rich Text Format [.rtf]\0*.rtf\0Text Files [.txt]\0*.txt\0Lotus 1-2-3 [.wk1;.wk3]\0*.wk1;*.wk3\0Microsoft Excel Worksheet [.xls;.xlw]\0*.xls;*.xlw\0Windows Write [.wri]\0*.wri\0WordPerfect 5.x [.doc]\0*.doc\0WordPerfect 6.x [.wpd;.doc]\0*.wpd;*.doc\0");
	ofn.nFilterIndex = 1;
	ofn.lpstrTitle = TEXT("Select One or More Files to Add to a Packed File");
	ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
		         OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_SHOWHELP | 
				 OFN_ALLOWMULTISELECT | OFN_HIDEREADONLY | OFN_ENABLETEMPLATE);
	ofn.lpstrDefExt = NULL;
	if (bWin2000OrGreater)
	{
		ofn.lpTemplateName = TEXT("WIPEAFTERPACKINGNEW");
	}
	else
	{
		ofn.lpTemplateName = TEXT("WIPEAFTERPACKING");
	}
	ofn.lpfnHook = MyPackOFNHookProc;

	// Setup the icon to use in the caption bar.
	//..........................................
	lpIconPointer = lpszAppName;

	// Select the files to pack.
	//..........................
	if (!GetOpenFileName(&ofn))
	{
		CommDlgBoxErrorProc(IDS_GET_FILES);
		goto AddEnd;
	}
	// Save a copy of the ofn structure.
	//..................................
	CopyMemory(&ofnPack,&ofn,sizeof(OPENFILENAME));

	// Determine the number of files we have to pack.
	// Used to setup the progress bar.
	//...............................................
	lpTempFilePtr = (lpFileReturn + ofn.nFileOffset);
	iNumberOfFiles = 0;
	while(TRUE)
	{
		if (*lpTempFilePtr == 0)
		{
			break;
		}
		iFileNameLength = lstrlen(lpTempFilePtr);
		iNumberOfFiles++;

		// Point to the next file selected. Get past the
		// trailing null byte.
		//..............................................
		lpTempFilePtr += (int)(iFileNameLength + 1);
	}
	// Setup the step increment for the progress bar.
	// Always equals one for this case.
	//...............................................
	iStepIncrement = 1;

	// Store the total number of files.
	//.................................
	iTotalFiles = iNumberOfFiles;

	// Setup the path for our selected files. If only 1 file
	// selected, we have the whole file spec.
	//......................................................
	ZeroMemory(&szDestination,MAX_PATH);
	StringCbCatEx((LPTSTR)&szDestination,sizeof(szDestination),lpFileReturn,NULL,NULL,
				   dwStringSafeFlag);

	if (iTotalFiles > 1)
	{
		SaveDirName((LPBYTE)&szDestination,SAVE_SOURCE,FALSE);
	}
	else
	{
		SaveDirName((LPBYTE)&szDestination,SAVE_SOURCE,TRUE);
	}
	// If we have more than one file we have to add a backslash.
	//.........................................................
	bMoreThanOne = FALSE;
	if (iNumberOfFiles > 1)
	{
		bMoreThanOne = TRUE;
		lpFileInsert = PathAddBackslash((LPTSTR)&szDestination);
	}
	lpTempFilePtr = (lpFileReturn + ofn.nFileOffset);

	// Build a crc32 table.
	//.....................
	bResult = Crc32Table(BUILD_TABLE);
	if (!bResult)
	{
		goto AddEnd;
	}
	// Build a list of the files in a packed file.
	//.................................................
	bResult = BuildPackedFileCentralDir((LPBYTE)&szFileName,hInputFile);
	if (!bResult)
	{
		goto AddEnd;
	}
	// Check to see if we have any new files to add to the packed file.
	//.................................................................
	iFilesToAdd = 0;
	uliScratch1.QuadPart = 0;
	iFilesInDir = pfidhdr.iFilesInVault;
	while(TRUE)
	{
		if (*lpTempFilePtr == 0)
		{
			break;
		}
		iFileNameLength = lstrlen(lpTempFilePtr);

		// Now go through the list in the central directory to see
		// if we have a match.
		//........................................................
		iTotalFiles = iFilesInDir;
		lppDir = lppfd;
		while(iTotalFiles > 0)
		{
			if (lppDir->pfh.wLengthOfFileName == iFileNameLength)
			{
				// The lengths are the same, see if we have an
				// actual match.
				//............................................
				iResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)lppDir->FileName,
										iFileNameLength,(LPCTSTR)lpTempFilePtr,
										iFileNameLength);

				if (iResult == CSTR_EQUAL)
				{
					break;
				}
			}
			__asm
			{
				mov		eax,dwHeaderSize
				add		lppDir,eax
			}
			iTotalFiles--;
		}
		// If iTotalFiles is 0, we have a new file to add to the
		// packed file.
		//......................................................
		if (iTotalFiles == 0)
		{
			iFilesToAdd++;
			pfidhdr.iFilesInVault++;
			
			// Get the files size so we can add it to the total size.
			//.......................................................
			if (bMoreThanOne)
			{
				*lpFileInsert = 0;
				StringCbCatEx((LPTSTR)&szDestination,sizeof(szDestination),lpTempFilePtr,
							   NULL,NULL,dwStringSafeFlag);
			}
			hSearch = FindFirstFile((LPCTSTR)&szDestination,&wfd);
			if (hSearch == INVALID_HANDLE_VALUE)
			{
				ErrorProcedure((LPTSTR)&szDestination,IDS_FINDFIRSTFILE,MB_OK);
				goto AddEnd;
			}
			FindClose(hSearch);
			uli.LowPart = wfd.nFileSizeLow;
			uli.HighPart = wfd.nFileSizeHigh;
			pfidhdr.uliTotalSizeOfFiles.QuadPart += uli.QuadPart;
			uliScratch1.QuadPart += uli.QuadPart;
		}
		// Check out the next file in the list.
		//.....................................
		lpTempFilePtr += (int)(iFileNameLength + 1);
	}
	// If we do not have any new files to add, say so and bail out.
	//.............................................................
	if (iFilesToAdd == 0)
	{
		SetLastError(IDS_NONEWFILESTOADD);
		ErrorProcedure((LPTSTR)&szFileName,IDS_READ,MB_OK);
		goto AddEnd;
	}
	iFilesToProcess = iFilesToAdd;

	// Determine what is a half percent for updating the progress bar.
	//................................................................
	if (uliScratch1.QuadPart < 40000)
	{
		__asm
		{
			xor		edx,edx
			mov		eax,uliScratch1.LowPart
			mov		ecx,200
			div		ecx
			cmp		eax,edx
			jae		L1
			inc		eax
		L1:	mov		liHalfPercent.HighPart,0
			mov		liHalfPercent.LowPart,eax
		}
	}
	else
	{
		liHalfPercent.QuadPart = (uliScratch1.QuadPart / 200);
	
		if (liHalfPercent.QuadPart == 0)
		{
			liHalfPercent.QuadPart = 1;
		}
	}
	liHalfPercentDup.QuadPart = liHalfPercent.QuadPart;

	// Setup the avi clip we will use.
	//................................
	iWhichAviClip = FILE_COPY;
	if (uiDriveType == DRIVE_REMOVABLE && (*szFileName == 0x41 ||
		*szDestination == 0x61 || *szDestination == 0x42 ||
		*szDestination == 0x62))
	{
		iWhichAviClip = FILE_DISK;
	}
	else if (uiDriveType == DRIVE_CDROM)
	{
		iWhichAviClip = FILE_CDROM;
	}
	// Allocate memory for input and output buffers.
	//..............................................
	lpInBuffer = AllocateMemory(BUFFER_SIZE_IN);
	lpOutBuffer = AllocateMemory(BUFFER_SIZE_OUT);
	if (!lpInBuffer || !lpOutBuffer)
	{
		goto AddEnd;
	}
	// Set the file pointer for the original packed file to point
	// to the first file header.
	//...........................................................
	uli.QuadPart = sizeof(PACKED_FILE_ID_HDR);
	uli.QuadPart = SetMyFilePointer((LPTSTR)&szFileName,hInputFile,uli.QuadPart,FILE_BEGIN);
	if (uli.QuadPart == -1)
	{
		goto AddEnd;
	}
	// Create a backup file to use for the new packed file.
	//.....................................................
	hTempFile = CreateMyFile((LPTSTR)&szTempFile,GENERIC_READ | GENERIC_WRITE,0,NULL,
						      CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hTempFile)
	{
		goto AddEnd;
	}
	// Write the new file header to the temporary file.
	//.................................................
	bResult = WriteMyFile((LPTSTR)&szTempFile,hTempFile,&pfidhdr,
						   sizeof(PACKED_FILE_ID_HDR),&dwBytesWritten,NULL);

	if (!bResult)
	{
		goto AddEnd;
	}
	// Transfer the old packed file to the new one.
	//.............................................
	while(TRUE)
	{
		bResult = ReadMyFile((LPTSTR)&szFileName,hInputFile,lpInBuffer,
							  BUFFER_SIZE_IN,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto AddEnd;
		}
		// Check for end of file.
		//.......................
		if (dwBytesRead == 0)
		{
			break;
		}
		bResult = WriteMyFile((LPTSTR)&szTempFile,hTempFile,lpInBuffer,
							   dwBytesRead,&dwBytesWritten,NULL);
		if (!bResult)
		{
			goto AddEnd;
		}
	}
	// Close the original packed file. It will be overwritten by
	// the new packed file if everything goes alright.
	//..........................................................
	bResult = CloseMyHandle((LPTSTR)&szFileName,hInputFile);
	if (!bResult)
	{
		goto AddEnd;
	}
	hInputFile = 0;

	// Setup to add files to a packed file.
	//.....................................
	bCancelOperation = FALSE;
	iNumberOfFiles = iFilesToAdd;
	hDialogModeLess = CreateDialog(hInst,TEXT("ADDTOAPACKEDFILE"),hMainWindow,
								  (DLGPROC)AddToAPackedFileProc);
	if (!hDialogModeLess)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto AddEnd;
	}
	// Start the avi clip.
	//....................
	if (bAviClipOK)
	{
		bAviClipOK = Animate_Play(hAviClip,0,-1,-1);
	}
	// Determine the final maximum code setting for the pack procedure.
	//.................................................................
	if (bWeHaveLzw)
	{
		SetMaxCodeSizeOnStartUp();

		// If the maximum pack code size is 0 we do not have enough
		// memory to pack any of the files.
		//.........................................................
		if (iMaxPack < 14)
		{
			SetLastError(IDS_NOTENOUGHMEMORYTOPACKWITH);
			ErrorProcedure((LPTSTR)lpszNA,IDS_ALLOCATEMEMORY,MB_OK);
			goto AddEnd;
		}
		SetLzwParameters((LPCODE_STATS)&CodeStats,iMaxPack);

		// Allocate the memory for code and hash tables.
		//..............................................
		lpCodeTable = AllocateMemory(dwCodeTableSize);
		lpHashTable = AllocateMemory(dwHashTableSize);
		if (!lpCodeTable || !lpHashTable)
		{
			goto AddEnd;
		}
	}
	// Setup some variables.
	//......................
	uliTotalCodes.QuadPart  = 0;
	uliInCount.QuadPart =0;
	uliFileCodes.QuadPart = 0;
	lpTempFilePtr = (lpFileReturn + ofn.nFileOffset);

	// While we have files left to pack.
	//..................................	
	while(TRUE)
	{
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			break;
		}
		if (*lpTempFilePtr == 0)
		{
			break;
		}
		iFileNameLength = lstrlen(lpTempFilePtr);

		// Now go through the list in the central directory to see
		// if we have a match.
		//........................................................
		iTotalFiles = iFilesInDir;
		lppDir = lppfd;
		while(iTotalFiles > 0)
		{
			if (lppDir->pfh.wLengthOfFileName == iFileNameLength)
			{
				// The lengths are the same, see if we have an
				// actual match.
				//............................................
				iResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)lppDir->FileName,
										iFileNameLength,(LPCTSTR)lpTempFilePtr,
										iFileNameLength);

				if (iResult == CSTR_EQUAL)
				{
					break;
				}
			}
			__asm
			{
				mov		eax,dwHeaderSize
				add		lppDir,eax
			}
			iTotalFiles--;
		}
		// If iTotalFiles is 0, we have a new file to add to the
		// packed file. szDestination for the file to pack. 
		// szTempFile for the temporary packed file. szBackUpFile
		// for this packed file.
		//.......................................................
		if (iTotalFiles == 0)
		{
			// Setup the path of the file to pack.
			//....................................
			if (bMoreThanOne)
			{
				*lpFileInsert = 0;
				StringCbCatEx((LPTSTR)&szDestination,sizeof(szDestination),
						      (LPCTSTR)lpTempFilePtr,NULL,NULL,dwStringSafeFlag);
			}
			// Get pointers to the file name and extension.
			//.............................................
			lpFileName = PathFindFileName((LPCTSTR)&szDestination);
			lpFileExtension = PathFindExtension((LPCTSTR)&szDestination);

			// Setup the file name and icon in the dialog box.
			//................................................
			SetDlgItemTextFmt(hDialogModeLess,IDC_FILE2,
							 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szDestination));

			if (hIcon)
			{
				DestroyIcon(hIcon);
				hIcon = 0;
			}
			hIcon = FindMyIcon((LPBYTE)&szFileName,lpFileExtension);

			// If we did not find one, use the default.
			//.........................................
			if (!hIcon)
			{
				hIcon = LoadImage(hInst,"I_FACEFROWN",IMAGE_ICON,32,32,LR_SHARED);
			}
			if (hIcon)
			{
				SendMessage(GetDlgItem(hDialogModeLess,IDC_ICON2),STM_SETICON,(WPARAM)hIcon,0);
			}
			// Open the file to pack.
			//.......................
			hDestination = CreateMyFile((LPTSTR)&szDestination,GENERIC_READ,0,NULL,
										 OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
			if (!hDestination)
			{
				goto AddEnd;
			}
			// Open a temporary file to hold the output of the compressor
			// until it can be determined if the file compressed or not.
			//...........................................................
			if (bWeHaveLzw)
			{
				hBackUpFile = CreateMyFile((LPTSTR)&szBackUpFile,GENERIC_READ | GENERIC_WRITE,
											0,NULL,CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);
				if (!hBackUpFile)
				{
					goto AddEnd;
				}
			}
			// Clear the file info header.
			//............................
			ZeroMemory(&pfhdr,sizeof(PACKED_FILE_HEADER));

			// Get the information on the file to see if we want to
			// pack it. If it is 0 length we skip it.
			//......................................................
			bResult = GetFileInformationByHandle(hDestination,&fi);
			if (!bResult)
			{
				ErrorProcedure((LPTSTR)&szDestination,IDS_GETFILEINFO,MB_OK);
				goto AddEnd;
			}
			if (fi.nFileSizeLow == 0 && fi.nFileSizeHigh == 0)
			{
				bResult = CloseMyHandle((LPTSTR)&szFileName,hInputFile);
				if (!bResult)
				{
					goto AddEnd;
				}
				hInputFile = 0;

				if (bWeHaveLzw)
				{
					bResult = CloseMyHandle((LPTSTR)&szBackUpFile,hBackUpFile);
					if (!bResult)
					{
						goto AddEnd;
					}
					hBackUpFile = 0;
					bResult = DeleteMyFile((LPTSTR)&szBackUpFile);
					if (!bResult)
					{
						goto AddEnd;
					}
				}
				// Go and check the next file in the list.
				//........................................
				lpTempFilePtr += (int)(iFileNameLength + 1);
				continue;
			}
			// Create the file header.
			//........................
			uli.LowPart = fi.nFileSizeLow;
			uli.HighPart = fi.nFileSizeHigh;
			pfhdr.dwFileAttributes = fi.dwFileAttributes;
			pfhdr.ftAccessed = fi.ftLastAccessTime;
			pfhdr.ftCreation = fi.ftCreationTime;
			pfhdr.ftLastWrite = fi.ftLastWriteTime;
			pfhdr.uliFileSize.QuadPart = uli.QuadPart;
			if (bWeHaveLzw)
			{
				pfhdr.LargestBitCode = LOBYTE(LOWORD(iMaxPack));
			}
			else
			{
				pfhdr.LargestBitCode = Z_BEST_COMPRESSION;
			}
			pfhdr.wLengthOfFileName = lstrlen((LPCTSTR)lpFileName);

			// Save a pointer to the file header so we can write the
			// final header after the file is compressed.
			//......................................................
			uliHdr.QuadPart = 0;
			uliHdr.QuadPart = SetMyFilePointer((LPTSTR)&szTempFile,hTempFile,
											    uliHdr.QuadPart,FILE_END);
			if (uliHdr.QuadPart == -1)
			{
				goto AddEnd;
			}
			// Write a preliminary file header for the file we 
			// are packing.
			//................................................
			bResult = WriteMyFile((LPTSTR)&szTempFile,hTempFile,&pfhdr,
								   sizeof(PACKED_FILE_HEADER),&dwBytesWritten,NULL);
			if (!bResult)
			{
				goto AddEnd;
			}
			uliOutCount.QuadPart += sizeof(PACKED_FILE_HEADER);

			// Now write the file name.
			//.........................
			bResult = WriteMyFile((LPTSTR)&szTempFile,hTempFile,lpFileName,lstrlen(lpFileName),
								   &dwBytesWritten,NULL);
			if (!bResult)
			{
				goto AddEnd;
			}
			uliOutCount.QuadPart += lstrlen(lpFileName);

			if (bWeHaveLzw)
			{
				// Compress the file.
				//...................
				bResult = CompressMyFile((LPBYTE)&szBackUpFile,hBackUpFile,
										(LPBYTE)&szDestination,hDestination);
				if (!bResult)
				{
					goto AddEnd;
				}
				// Determine if the file compressed ok or not.
				// If not, adjust some values.
				//............................................
				if (uliFileOut.QuadPart > uliFileIn.QuadPart)
				{
					pfhdr.LargestBitCode = 0;
					uliTotalCodes.QuadPart -= uliFileCodes.QuadPart;
					uliFileCodes.QuadPart = 0;
					pfhdr.uliCompressedFileSize.QuadPart = pfhdr.uliFileSize.QuadPart;
					uliTotalCodes.QuadPart += pfhdr.uliFileSize.QuadPart;
					uliOutCount.QuadPart += pfhdr.uliFileSize.QuadPart;
					uliOutCount.QuadPart -= uliFileOut.QuadPart;
					lpTransferFile = szDestination;
					hTransferFile = hDestination;
				}
				else
				{
					lpTransferFile = szBackUpFile;
					hTransferFile = hBackUpFile;
				}
				// Transfer the temporary file, or packed file as the case
				// may be, to the compressed file. First rewind the file to
				// transfer.
				//.........................................................
				uli.QuadPart = 0;
				uli.QuadPart = SetMyFilePointer((LPTSTR)lpTransferFile,
												 hTransferFile,uli.QuadPart,FILE_BEGIN);
				if (uli.QuadPart == -1)
				{
					goto AddEnd;
				}
				uli.QuadPart = pfhdr.uliCompressedFileSize.QuadPart;

				while(uli.QuadPart > 0)
				{
					if (uli.QuadPart > BUFFER_SIZE_IN)
					{
						dwBytesToRead = BUFFER_SIZE_IN;
						uli.QuadPart -= BUFFER_SIZE_IN;
					}
					else
					{
						dwBytesToRead = uli.LowPart;
						uli.QuadPart = 0;
					}
					bResult = ReadMyFile((LPTSTR)lpTransferFile,hTransferFile,
										  lpInBuffer,dwBytesToRead,&dwBytesRead,NULL);
					if (!bResult)
					{
						goto AddEnd;
					}
					bResult = WriteMyFile((LPTSTR)&szTempFile,hTempFile,lpInBuffer,dwBytesRead,
										   &dwBytesWritten,NULL);
					if (!bResult)
					{
						goto AddEnd;
					}
				}
			}
			else
			{
				bResult = ZipMyFile((LPBYTE)&szTempFile,hTempFile,(LPBYTE)&szDestination,
									 hDestination);
				if (!bResult)
				{
					goto AddEnd;
				}
			}
			// Finalize the crc32 value for the file in the header.
			//.....................................................
			if (bWeHaveLzw)
			{
				pfhdr.dwFileCrc32 ^= -1;
			}
			// Calculate the header crc32 value for the file and write
			// the whole header to disk again.
			//...............................................
			CalculateHeaderCrc();
			uliHdr.QuadPart = SetMyFilePointer((LPTSTR)&szTempFile,hTempFile,
												uliHdr.QuadPart,FILE_BEGIN);
			if (uliHdr.QuadPart == -1)
			{
				goto AddEnd;
			}
			bResult = WriteMyFile((LPTSTR)&szTempFile,hTempFile,
								  &pfhdr,sizeof(PACKED_FILE_HEADER),&dwBytesWritten,NULL);
			if (!bResult)
			{
				goto AddEnd;
			}
			if (bWeHaveLzw)
			{
				// Close and delete the temporary backup file.
				//............................................
				bResult = CloseMyHandle((LPTSTR)&szBackUpFile,hBackUpFile);
				if (!bResult)
				{
					goto AddEnd;
				}
				hBackUpFile = 0;

				bResult = WipeMyFile((LPTSTR)&szBackUpFile,FALSE);
				if (bResult)
				{
					goto AddEnd;
				}
			}
			// Close the file we just packed.
			//...............................
			bResult = CloseMyHandle((LPTSTR)&szDestination,hDestination);
			if (!bResult)
			{
				goto AddEnd;
			}
			hDestination = 0;

			// If we have an icon open, delete it, but only if we have
			// more files to pack.
			//........................................................
			if (hIcon && iNumberOfFiles > 1)
			{
				DestroyIcon(hIcon);
				hIcon = 0;
			}
		}
		iNumberOfFiles--;

		// Go and check the next file in the list.
		//........................................
		lpTempFilePtr += (int)(iFileNameLength + 1);
	}
	// Get the final file size of the packed file.
	//............................................
	uliFinalFileSize.QuadPart = 0;
	uliFinalFileSize.QuadPart = SetMyFilePointer((LPTSTR)&szTempFile,hTempFile,
												 uliFinalFileSize.QuadPart,FILE_END);
	if (uliFinalFileSize.QuadPart == -1)
	{
		goto AddEnd;
	}
	// Close the temporary packed file.
	//.................................
	bResult = CloseMyHandle((LPTSTR)&szTempFile,hTempFile);
	if (!bResult)
	{
		goto AddEnd;
	}
	hTempFile = 0;

	// Copy the new packed file over the old packed file.
	//...................................................
	bResult = CopyFile((LPCTSTR)&szTempFile,(LPCTSTR)&szFileName,FALSE);
	if (!bResult)
	{
		ErrorProcedure((LPTSTR)&szFileName,IDS_COPYFILE,MB_OK);
		goto AddEnd;
	}
	// Set the position of the progress bar to 100% if we did not quit
	// or exit with an error
	//................................................................
	if (!bCancelOperation)
	{
		SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_SETPOS,(WPARAM)200,0);
	}
	// Make sure bCancelOperation is set to FALSE.
	//............................................
	bCancelOperation = FALSE;

	// Stop the avi clip.
	//...................
	if (bAviClipOK)
	{
		bAviClipOK = Animate_Stop(hAviClip);
	}
	// Change the cancel button to ok.
	//................................
	SetDlgItemText(hDialogModeLess,IDCANCEL,TEXT("&OK"));

	FlashMyIcon(TRUE);

	// Wait until we close the dialog box to exit.
	//............................................
	while(TRUE)
	{
		CheckForMessages();
		if (bCancelOperation == TRUE)
		{
			break;
		}
	}
	bDiskError = FALSE;

	AddEnd:

	FlashMyIcon(FALSE);

	Crc32Table(DELETE_TABLE);

	if (hIcon)
	{
		DestroyIcon(hIcon);
		hIcon = 0;
	}
	if (bAviClipOK)
	{
		Animate_Close(hAviClip);
	}
	if (hDialogModeLess)
	{
		DestroyWindow(hDialogModeLess);
	}
	if (lppfd)
	{
		DeallocateMemory(lppfd);
		lppfd = 0;
	}
	if (lpInBuffer)
	{
		ZeroMemory(lpInBuffer,BUFFER_SIZE_IN);
		DeallocateMemory(lpInBuffer);
		lpInBuffer = 0;
	}
	if (lpOutBuffer)
	{
		ZeroMemory(lpOutBuffer,BUFFER_SIZE_OUT);
		DeallocateMemory(lpOutBuffer);
		lpOutBuffer = 0;
	}
	if (lpCodeTable)
	{
		ZeroMemory(lpCodeTable,dwCodeTableSize);
		DeallocateMemory(lpCodeTable);
		lpCodeTable = 0;
	}
	if (lpHashTable)
	{
		ZeroMemory(lpHashTable,dwHashTableSize);
		DeallocateMemory(lpHashTable);
		lpHashTable = 0;
	}
	if (hInputFile)
	{
		CloseMyHandle((LPTSTR)&szFileName,hInputFile);
		hInputFile = 0;
	}
	if (hTempFile)
	{
		CloseMyHandle((LPTSTR)&szTempFile,hTempFile);
		DeleteMyFile((LPTSTR)&szTempFile);
	}
	if (hDestination)
	{
		CloseMyHandle((LPTSTR)&szDestination,hDestination);
	}
	if (hBackUpFile)
	{
		CloseMyHandle((LPTSTR)&szBackUpFile,hBackUpFile);
		WipeMyFile((LPTSTR)&szBackUpFile,TRUE);
		hBackUpFile = 0;
	}
	// Show the final status of the packed file.
	//..........................................
	if (!bDiskError)
	{
		CopyMemory(&szDestination,&szFileName,MAX_PATH);
		iResult = DialogBox(hInst,TEXT("PACKEDFILESTATUS"),hMainWindow,
						   (DLGPROC)PackedFileStatusProc);

		// See if we had a system error in creating the dialog box.
		//.........................................................
		if (iResult == -1)
		{
			ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		}
		// See if we want to wipe the files we just packed.
		//.................................................
		if (bWipeAfterPacking && iResult != -1)
		{
			bWipeFiles = TRUE;
			bCancelOperation = FALSE;
			DeleteWipeFiles(lpFileReturn,&ofnPack);
		}
		else
		{
			if (lpFileReturn)
			{
				DeallocateMemory(lpFileReturn);
			}
		}
		lpFileReturn = 0;
	}
	if (lpFileReturn)
	{
		ZeroMemory(lpFileReturn,((64 *1024) -1));
		DeallocateMemory(lpFileReturn);
	}
	// We copied the file ok. Wipe the temp packed file.
	//..................................................
	if (!bDiskError)
	{
		WipeMyFile((LPTSTR)&szTempFile,TRUE);
	}

	bCancelOperation = FALSE;
	ChangeHelpTopic(dwOldHelpTopic);
	bProcessInProgress = FALSE;
}

// CALLBACK procedure for adding files to a packed file.
//......................................................
LRESULT CALLBACK AddToAPackedFileProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Open the avi clip and display its first frame
			// in the animation control.
			//..............................................
			hAviClip = GetDlgItem(hDlg,IDC_ANIMATE);
			bAviClipOK = Animate_Open(hAviClip,(LPSTR)iWhichAviClip);

			// Setup the range and step increment for the progress bar.
			//.........................................................
			SendMessage(GetDlgItem(hDlg,IDC_PROGRESS),PBM_SETRANGE32,0,(LPARAM)200);
			SendMessage(GetDlgItem(hDlg,IDC_PROGRESS),PBM_SETSTEP,(WPARAM)iStepIncrement,0);

			// Setup the name of the packed file.
			//...................................
			SetDlgItemTextFmt(hDlg,IDC_FILE1,(LPCTSTR)GetDisplayName(&shfi1,
							 (LPCTSTR)&szFileName));

			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDCANCEL));
			return(FALSE);
		}

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				// Inform the procedure that we want to quit.
				//...........................................
				case IDCANCEL:
				{
					bCancelOperation = TRUE;
				}
				break;
			}
		}
		break;

		case WM_DESTROY:
		{
			hDialogModeLess = NULL;
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Freshen a packed file.
//.......................
VOID FreshenAPackedFile()
{
	WIN32_FIND_DATA		wfd;
	ULARGE_INTEGER		uliFreeCallerBytes;
	ULARGE_INTEGER		uliTotalBytes;
	ULARGE_INTEGER		uli;
	ULARGE_INTEGER		uliHdr;
	ULARGE_INTEGER		uliScratch1;
	OPENFILENAME		ofn;
	HRESULT				hr = ERROR_SUCCESS;
	DWORD				dwOldHelpTopic;
	LPBYTE				lpTransferFile;
	HANDLE				hTransferFile;
	BOOL				bResult;
	DWORD				dwBytesRead;
	DWORD				dwBytesToRead;
	DWORD				dwBytesWritten;
	DWORD				dwFilesFreshened = 0;
	UINT				uiDriveType;
	DWORD				dwDestinationLength;
	DWORD				dwFilesToFreshen = 0;
	DWORD				dwLastError;
	int					iFilesLeft;
	int					iResult;
	BOOL				bDiskError;
	HANDLE				hSearch;
	HANDLE				hTempFile = 0;
	HANDLE				hDestination = 0;
	BROWSEINFO			bi;
    LPITEMIDLIST		lpidl;
    LPMALLOC			lpMalloc;
	TCHAR				szRoot[16];
	TCHAR				szOutBuffer[132];
	TCHAR				szPackedFile[MAX_PATH];
	TCHAR				szTempFile[MAX_PATH];

	bProcessInProgress = TRUE;
	dwOldHelpTopic = ChangeHelpTopic(IDH_FRESHEN);
	bAviClipOK = FALSE;
	bDiskError = TRUE;

	// Setup a temporary file for packing.
	//....................................
	GetTempPath(MAX_PATH,(LPTSTR)&szTempFile);
	GetTempFileName((LPTSTR)&szTempFile,TEXT("pkd"),0,(LPTSTR)&szTempFile);
	bResult = DeleteMyFile((LPTSTR)&szTempFile);
	if (!bResult)
	{
		goto FreshEnd;
	}
	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_SOURCE);

	// Initialize with specific information for this procedure.
	//.........................................................
	ofn.lpstrFile = szFileName;
	ofn.nMaxFile = sizeof(szFileName);
	ofn.hwndOwner = hMainWindow;
	ofn.lpstrFilter = TEXT("Packed Files [.pkd]\0*.pkd\0All Files [*.*]\0*.*\0");
	ofn.nFilterIndex = 1;
	ofn.lpstrTitle = TEXT("Select a Packed File to Freshen");
	ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
		         OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_SHOWHELP | 
				 OFN_HIDEREADONLY);
	ofn.lpstrDefExt = NULL;
	ofn.lpfnHook = MyOFNHookProc;

	// Setup the icon to use in the caption bar.
	//..........................................
	lpIconPointer = lpszAppName;

	while(TRUE)
	{
		ZeroMemory(&szFileName,sizeof(szFileName));

		// Select the packed file to freshen.
		//...................................
		if (!GetOpenFileName(&ofn))
		{
			CommDlgBoxErrorProc(IDS_GET_FILES);
			goto FreshEnd;
		}
		SaveDirName((LPBYTE)&szFileName,SAVE_SOURCE,TRUE);

		// Make sure the file is a valid packed file.
		//...........................................
		lpFileName = PathFindFileName((LPCTSTR)&szFileName);
		lpFileExtension = PathFindExtension((LPCTSTR)&szFileName);

		hInputFile = IsValidPackedFile((LPBYTE)&szFileName,TRUE);

		if (hInputFile)
		{
			// See if we have any free disk space. cd rom drives that
			// are not writable will report zero. Use szDestinaiton
			// to setup a directory name.
			//.......................................................
			CopyMemory(&szDestination,&szFileName,sizeof(szFileName));
			PathRemoveFileSpec((LPTSTR)&szDestination);
			ZeroMemory(&szRoot,sizeof(szRoot));
			CopyMemory(&szRoot,&szDestination,3);
			bResult = GetDiskFreeSpaceEx((LPCTSTR)&szRoot,
										(PULARGE_INTEGER)&uliFreeCallerBytes.QuadPart,
										(PULARGE_INTEGER)&uliTotalBytes.QuadPart,NULL);
			if (!bResult)
			{
				ErrorProcedure((LPTSTR)&szDestination,IDS_GETFREEDSKSPACE,MB_OK);
				goto FreshEnd;
			}
			if (uliFreeCallerBytes.QuadPart == 0)
			{
				SetLastError(IDS_NOSPACEFRESHEN);
				ErrorProcedure((LPTSTR)&szFileName,IDS_GETFREEDSKSPACE,MB_OK);

				// Close the file and try again.
				//..............................
				goto TryAgain;
			}
			break;
		}
		// We do not have a valid packed file.
		//....................................
		SetLastError(IDS_INVALIDPACKEDFILE);
		ErrorProcedure((LPTSTR)&szFileName,IDS_READ,MB_OK);
	
		// Close the file and try again.
		//..............................
	  TryAgain:
		bResult = CloseMyHandle((LPTSTR)&szFileName,hInputFile);
		if (!bResult)
		{
			goto FreshEnd;
		}
		hInputFile = 0;
	}
	EmptyTheMessageQue();

	// Setup the step increment for the progress bar.
	// Always equals one for this case.
	//...............................................
	iStepIncrement = 1;

	iNumberOfFiles = pfidhdr.iFilesInVault;

	// Select a folder to freshen the packed file from.
	//.................................................
	ZeroMemory(&szDestination,sizeof(szDestination));

	if (SUCCEEDED(SHGetMalloc(&lpMalloc))) 
	{
		ZeroMemory(&bi,sizeof(bi));
		bi.hwndOwner = hMainWindow;
		bi.pszDisplayName = 0;
		bi.lpszTitle = TEXT("Select a folder to freshen the packed file from.");
		bi.pidlRoot = 0;
		bi.ulFlags = BIF_RETURNONLYFSDIRS | BIF_BROWSEINCLUDEFILES;

		// If we can use the new style of the dialog box, do it.
		//......................................................
		if (bUseNew)
		{
			hr = CoInitialize(NULL);
			if (SUCCEEDED(hr))
			{
				bi.ulFlags |= BIF_NEWDIALOGSTYLE;
			}
		}
		bi.lpfn = BrowseCallbackProc;

		lpidl = SHBrowseForFolder(&bi);

		if (bUseNew && SUCCEEDED(hr))
		{
			CoUninitialize();
		}
		if (lpidl) 
		{
			bResult = SHGetPathFromIDList(lpidl,(LPSTR)&szDestination);
			lpMalloc->lpVtbl->Free(lpMalloc,lpidl);
			lpMalloc->lpVtbl->Release(lpMalloc);
		}
		else
		{
			// We cancelled out.
			//..................
			goto FreshEnd;
		}
		// Get the drive type so we can determine which avi
		// clip to use.
		//.................................................
		ZeroMemory(&szRoot,sizeof(szRoot));
		CopyMemory(&szRoot,&szDestination,sizeof(szRoot));
		PathStripToRoot((LPTSTR)&szRoot);
		uiDriveType = GetDriveType((LPCTSTR)&szRoot);
	}
	else
	{
		MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_SELECTDIR,
					   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
		goto FreshEnd;
	}
	// Remove any file name that may be with the selected directory.
	//..............................................................
	if (!PathIsDirectory((LPCTSTR)&szDestination))
	{
		PathRemoveFileSpec((LPTSTR)&szDestination);
	}
	SaveDirName((LPBYTE)&szDestination,SAVE_SOURCE,FALSE);

	lpAppendPtr = PathAddBackslash((LPTSTR)&szDestination);
	dwDestinationLength = lstrlen((LPCTSTR)&szDestination);

	// Build a crc32 table.
	//.....................
	bResult = Crc32Table(BUILD_TABLE);
	if (!bResult)
	{
		goto FreshEnd;
	}
	// Check to see if we have any files to freshen at all.
	//.....................................................
	uliScratch1.QuadPart = 0;
	iFilesLeft = pfidhdr.iFilesInVault;
	while (iFilesLeft)
	{
		ZeroMemory(&szPackedFile,MAX_PATH);
		bResult = ReadMyFile((LPTSTR)&szFileName,hInputFile,&pfhdr,
							  sizeof(PACKED_FILE_HEADER),&dwBytesRead,NULL);

		// If we did not read in the required number of bytes.
		//....................................................
		if (dwBytesRead != sizeof(PACKED_FILE_HEADER))
		{
			SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
			ErrorProcedure((LPTSTR)&szFileName,IDS_READ,MB_OK);
			goto FreshEnd;
		}
		if (!bResult)
		{
			goto FreshEnd;
		}
		// Check the header crc32 value.
		//..............................
		bResult = CheckHeaderCrc();
		if (!bResult)
		{
			goto FreshEnd;
		}		
		// Read in the file name which follows the header.
		//................................................
		bResult = ReadMyFile((LPTSTR)&szFileName,hInputFile,&szPackedFile,
							  pfhdr.wLengthOfFileName,&dwBytesRead,NULL);

		// If we did not read in the required number of bytes.
		//....................................................
		if (dwBytesRead != pfhdr.wLengthOfFileName)
		{
			SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
			ErrorProcedure((LPTSTR)&szFileName,IDS_READ,MB_OK);
			goto FreshEnd;
		}
		if (!bResult)
		{
			goto FreshEnd;
		}
		// If the source path plus the file name exceeds MAX_PATH
		// we have to skip this file.
		//.......................................................
		if ((dwDestinationLength + pfhdr.wLengthOfFileName) > MAX_PATH)
		{
			SetLastError(IDS_PATHTOOLONGFRESHEN);
			ErrorProcedure((LPTSTR)&szPackedFile,IDS_CREATE_OPEN,MB_OK);

			// We have to get past the compressed data to the next
			// file header.
			//....................................................
		  CheckNextFile:
			uli.QuadPart = SetMyFilePointer((LPTSTR)&szFileName,hInputFile,
											 pfhdr.uliCompressedFileSize.QuadPart,
											 FILE_CURRENT);
			if (uli.QuadPart == -1)
			{
				goto FreshEnd;
			}
			iFilesLeft--;
			continue;
		}
		*lpAppendPtr = 0;
		StringCbCatEx((LPTSTR)&szDestination,sizeof(szDestination),(LPCTSTR)&szPackedFile,
					   NULL,NULL,dwStringSafeFlag);

		// Get information about the file.
		//................................
		hSearch = FindFirstFile((LPCTSTR)&szDestination,&wfd);

		if (hSearch == INVALID_HANDLE_VALUE)
		{
			dwLastError = GetLastError();
			if (dwLastError == ERROR_FILE_NOT_FOUND)
			{
				goto CheckNextFile;
			}
			else
			{
				SetLastError(dwLastError);
				ErrorProcedure((LPTSTR)&szDestination,IDS_FINDFIRSTFILE,MB_OK);
				goto FreshEnd;
			}
		}
		// Close the search handle for this file.
		//.......................................
		FindClose(hSearch);

		// We have found the file. See if it needs to be freshened.
		//.........................................................
		if (wfd.ftLastWriteTime.dwHighDateTime  > 
			pfhdr.ftLastWrite.dwHighDateTime || 
		   (wfd.ftLastWriteTime.dwHighDateTime == 
		    pfhdr.ftLastWrite.dwHighDateTime && 
			wfd.ftLastWriteTime.dwLowDateTime >
			pfhdr.ftLastWrite.dwLowDateTime))
		{
			dwFilesToFreshen++;
			pfidhdr.uliTotalSizeOfFiles.QuadPart -= pfhdr.uliFileSize.QuadPart;
			uli.LowPart = wfd.nFileSizeLow;
			uli.HighPart = wfd.nFileSizeHigh;
			pfidhdr.uliTotalSizeOfFiles.QuadPart += uli.QuadPart;
			uliScratch1.QuadPart += uli.QuadPart;
		}
		goto CheckNextFile;
	}
	if (dwFilesToFreshen == 0)
	{
		SetLastError(IDS_NOFILESTOFRESHEN);
		ErrorProcedure((LPTSTR)&szFileName,IDS_READ,MB_OK);
		goto FreshEnd;
	}
	// Determine what is a half percent for updating the progress bar.
	//................................................................
	if (uliScratch1.QuadPart < 40000)
	{
		__asm
		{
			xor		edx,edx
			mov		eax,uliScratch1.LowPart
			mov		ecx,200
			div		ecx
			cmp		eax,edx
			jae		L1
			inc		eax
		L1:	mov		liHalfPercent.HighPart,0
			mov		liHalfPercent.LowPart,eax
		}
	}
	else
	{
		liHalfPercent.QuadPart = (uliScratch1.QuadPart / 200);
	
		if (liHalfPercent.QuadPart == 0)
		{
			liHalfPercent.QuadPart = 1;
		}
	}
	liHalfPercentDup.QuadPart = liHalfPercent.QuadPart;

	// Reset the file pointer to point to the first header in the
	// packed file.
	//...........................................................
	uli.QuadPart = sizeof(pfidhdr);
	uli.QuadPart = SetMyFilePointer((LPTSTR)&szFileName,hInputFile,uli.QuadPart,FILE_BEGIN);
	if (uli.QuadPart == -1)
	{
		goto FreshEnd;
	}
	// Setup the avi clip we will use.
	//................................
	iWhichAviClip = FILE_COPY;
	if (uiDriveType == DRIVE_REMOVABLE && (*szFileName == 0x41 ||
		*szDestination == 0x61 || *szDestination == 0x42 ||
		*szDestination == 0x62))
	{
		iWhichAviClip = FILE_DISK;
	}
	else if (uiDriveType == DRIVE_CDROM)
	{
		iWhichAviClip = FILE_CDROM;
	}
	// Allocate memory for input and output buffers.
	//..............................................
	lpInBuffer = AllocateMemory(BUFFER_SIZE_IN);
	lpOutBuffer = AllocateMemory(BUFFER_SIZE_OUT);
	if (!lpInBuffer || !lpOutBuffer)
	{
		goto FreshEnd;
	}
	// Setup the modeless dialog box for unpacking our files.
	//.......................................................
	bCancelOperation = FALSE;
	hDialogModeLess = CreateDialog(hInst,TEXT("FRESHENPACKEDFILE"),hMainWindow,
								  (DLGPROC)FreshenPackedFileProc);

	if (!hDialogModeLess)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto FreshEnd;
	}
	// Start the avi clip.
	//....................
	if (bAviClipOK)
	{
		bAviClipOK = Animate_Play(hAviClip,0,-1,-1);
	}
	// Determine the final maximum code setting for the pack procedure.
	//.................................................................
	SetMaxCodeSizeOnStartUp();

	// If the maximum pack code size is 0 we do not have enough
	// memory to pack any of the files.
	//.........................................................
	if (bWeHaveLzw)
	{
		if (iMaxPack < 14)
		{	
			SetLastError(IDS_NOTENOUGHMEMORYTOPACKWITH);
			ErrorProcedure((LPTSTR)lpszNA,IDS_ALLOCATEMEMORY,MB_OK);
			goto FreshEnd;
		}
		SetLzwParameters((LPCODE_STATS)&CodeStats,iMaxPack);

		// Allocate the memory for code and hash tables.
		//..............................................
		lpCodeTable = AllocateMemory(dwCodeTableSize);
		lpHashTable = AllocateMemory(dwHashTableSize);
		if (!lpCodeTable || !lpHashTable)
		{
			goto FreshEnd;
		}
	}
	// Open a temporary output file for the new packed file.
	//......................................................
	hBackUpFile = CreateMyFile((LPTSTR)&szBackUpFile,GENERIC_READ | GENERIC_WRITE,0,NULL,
							    CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hBackUpFile)
	{
		goto FreshEnd;
	}
	// Write the new file header out to disk.
	//.......................................
	bResult = WriteMyFile((LPTSTR)&szBackUpFile,hBackUpFile,&pfidhdr,
						   sizeof(PACKED_FILE_ID_HDR),&dwBytesWritten,NULL);
	if (!bResult)
	{
		goto FreshEnd;
	}
	// Setup some variables.
	//......................
	uliTotalCodes.QuadPart  = 0;
	uliInCount.QuadPart =0;
	uliFileCodes.QuadPart = 0;
	uliOutCount.QuadPart = sizeof(PACKED_FILE_ID_HDR);

	// Process the packed file.
	//.........................
	while(iNumberOfFiles > 0)
	{
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			goto FreshEnd;
		}
		// Get the position for the next file header in the
		// backup file.
		//.................................................
		uliHdr.QuadPart = 0;
		uliHdr.QuadPart = SetMyFilePointer((LPTSTR)&szBackUpFile,hBackUpFile,uliHdr.QuadPart,
										    FILE_END);
		if (uliHdr.QuadPart == -1)
		{
			goto FreshEnd;
		}
		// Read in a file header and name and check to see if we 
		// need to freshen the file.
		//......................................................
		ZeroMemory(&szPackedFile,MAX_PATH);
		bResult = ReadMyFile((LPTSTR)&szFileName,hInputFile,&pfhdr,
							 sizeof(PACKED_FILE_HEADER),&dwBytesRead,NULL);

		// If we did not read in the required number of bytes.
		//....................................................
		if (dwBytesRead != sizeof(PACKED_FILE_HEADER))
		{
			SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
			ErrorProcedure((LPTSTR)&szFileName,IDS_READ,MB_OK);
			goto FreshEnd;
		}
		if (!bResult)
		{
			goto FreshEnd;
		}
		// Check the header crc32 value.
		//..............................
		bResult = CheckHeaderCrc();
		if (!bResult)
		{
			goto FreshEnd;
		}		
		// Read in the file name which follows the header.
		//................................................
		bResult = ReadMyFile((LPTSTR)&szFileName,hInputFile,
							  &szPackedFile,pfhdr.wLengthOfFileName,&dwBytesRead,NULL);

		// If we did not read in the required number of bytes.
		//....................................................
		if (dwBytesRead != pfhdr.wLengthOfFileName)
		{
			SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
			ErrorProcedure((LPTSTR)&szFileName,IDS_READ,MB_OK);
			goto FreshEnd;
		}
		if (!bResult)
		{
			goto FreshEnd;
		}
		*lpAppendPtr = 0;
		StringCbCatEx((LPTSTR)&szDestination,sizeof(szDestination),(LPCTSTR)&szPackedFile,
					   NULL,NULL,dwStringSafeFlag);
		lpAppendExt = PathFindExtension((LPCTSTR)&szDestination);

		// Get information about the file.
		//................................
		hSearch = FindFirstFile((LPCTSTR)&szDestination,&wfd);

		if (hSearch == INVALID_HANDLE_VALUE)
		{
			dwLastError = GetLastError();
			if (dwLastError == ERROR_FILE_NOT_FOUND)
			{
				goto CopyThisFile;
			}
			else
			{
				SetLastError(dwLastError);
				ErrorProcedure((LPTSTR)&szDestination,IDS_FINDFIRSTFILE,MB_OK);
				goto FreshEnd;
			}
		}
		// Close the search handle for this file.
		//.......................................
		FindClose(hSearch);

		// If the file is not newer, just copy the old one.
		//.................................................
		if (wfd.ftLastWriteTime.dwHighDateTime  < 
			pfhdr.ftLastWrite.dwHighDateTime || 
		   (wfd.ftLastWriteTime.dwHighDateTime == 
		    pfhdr.ftLastWrite.dwHighDateTime && 
			wfd.ftLastWriteTime.dwLowDateTime <=
			pfhdr.ftLastWrite.dwLowDateTime))
		{
		  CopyThisFile:

			// Copy the header and name to the backup file.
			//.............................................
			bResult = WriteMyFile((LPTSTR)&szBackUpFile,hBackUpFile,
								   &pfhdr,sizeof(PACKED_FILE_HEADER),&dwBytesWritten,NULL);
			if (!bResult)
			{
				goto FreshEnd;
			}
			bResult = WriteMyFile((LPTSTR)&szBackUpFile,hBackUpFile,
								   &szPackedFile,pfhdr.wLengthOfFileName,&dwBytesWritten,NULL);
			if (!bResult)
			{
				goto FreshEnd;
			}
			// Copy the compressed data.
			//..........................
			while(pfhdr.uliCompressedFileSize.QuadPart > 0)
			{
				if (pfhdr.uliCompressedFileSize.QuadPart > BUFFER_SIZE_IN)
				{
					pfhdr.uliCompressedFileSize.QuadPart -= BUFFER_SIZE_IN;
					dwBytesToRead = BUFFER_SIZE_IN;
				}
				else
				{
					dwBytesToRead = pfhdr.uliCompressedFileSize.LowPart;
					pfhdr.uliCompressedFileSize.QuadPart = 0;
				}
				bResult = ReadMyFile((LPTSTR)&szFileName,hInputFile,
									 lpInBuffer,dwBytesToRead,&dwBytesRead,NULL);

				// If we did not read in the required number of bytes.
				//....................................................
				if (dwBytesRead != dwBytesToRead)
				{
					SetLastError(IDS_BYTESREADNOTEQUALTOREQUEST);
					ErrorProcedure((LPTSTR)&szFileName,IDS_READ,MB_OK);
					goto FreshEnd;
				}
				if (!bResult)
				{
					goto FreshEnd;
				}
				bResult = WriteMyFile((LPTSTR)&szBackUpFile,hBackUpFile,
									   lpInBuffer,dwBytesRead,&dwBytesWritten,NULL);
				if (!bResult)
				{
					goto FreshEnd;
				}
			}
		}
		else
		{
			if (hIcon2)
			{
				DestroyIcon(hIcon2);
				hIcon2 = 0;
			}

			hIcon2 = FindMyIcon((LPBYTE)&szDestination,lpAppendExt);

			// If we did not find one, use the default.
			//.........................................
			if (!hIcon2)
			{
				hIcon2 = LoadImage(hInst,"I_FACEFROWN",IMAGE_ICON,32,32,LR_SHARED);
			}
			if (hIcon2)
			{
				SendMessage(GetDlgItem(hDialogModeLess,IDC_ICON2),STM_SETICON,
						   (WPARAM)hIcon2,0);
			}
			// Display the files name.
			//........................
			SetDlgItemTextFmt(hDialogModeLess,IDC_FILE2,
							 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szDestination));

			// Compress the newer file. First adjust the the old
			// packed file pointer to point to the next file header.
			//......................................................
			uli.QuadPart = pfhdr.uliCompressedFileSize.QuadPart;
			uli.QuadPart = SetMyFilePointer((LPTSTR)&szFileName,hInputFile,uli.QuadPart,
											 FILE_CURRENT);
			if (uli.QuadPart == -1)
			{
				goto FreshEnd;
			}
			// Make sure the comp bits is set to the correct value in
			// the header, comp size is set to 0, and the date, time,
			// size, attributes, etc. are set to their new values.
			//........................................................
			if (bWeHaveLzw)
			{
				pfhdr.LargestBitCode = LOBYTE(LOWORD(iMaxPack));
			}
			else
			{
				pfhdr.LargestBitCode = Z_BEST_COMPRESSION;
			}
			pfhdr.dwFileAttributes = wfd.dwFileAttributes;
			pfhdr.ftAccessed = wfd.ftLastAccessTime;
			pfhdr.ftCreation = wfd.ftCreationTime;
			pfhdr.ftLastWrite = wfd.ftLastWriteTime;
			pfhdr.uliFileSize.LowPart = wfd.nFileSizeLow;
			pfhdr.uliFileSize.HighPart = wfd.nFileSizeHigh;
			pfhdr.uliCompressedFileSize.QuadPart = 0;

			// Write the new header to the temporary packed file.
			//...................................................
			bResult = WriteMyFile((LPTSTR)&szBackUpFile,hBackUpFile,
								   &pfhdr,sizeof(PACKED_FILE_HEADER),&dwBytesWritten,NULL);
			if (!bResult)
			{
				goto FreshEnd;
			}
			// Write the file name after the header.
			//......................................
			bResult = WriteMyFile((LPTSTR)&szBackUpFile,hBackUpFile,
								   lpAppendPtr,pfhdr.wLengthOfFileName,&dwBytesWritten,NULL);
			if (!bResult)
			{
				goto FreshEnd;
			}
			// Open the file to be freshened, ie. packed.
			//...........................................
			hDestination = CreateMyFile((LPTSTR)&szDestination,GENERIC_READ,0,NULL,
									     OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
			if (!hDestination)
			{
				goto FreshEnd;
			}
			if (bWeHaveLzw)
			{
				// Create a temporary file for packing.
				//.....................................
				hTempFile = CreateMyFile((LPTSTR)&szTempFile,GENERIC_READ | GENERIC_WRITE,0,
										  NULL,CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);
				if (!hTempFile)
				{
					goto FreshEnd;
				}
				// Compress the file.
				//...................
				bResult = CompressMyFile((LPBYTE)&szTempFile,hTempFile,(LPBYTE)&szDestination,
									      hDestination);
				if (!bResult)
				{
					goto FreshEnd;
				}
				// Finalize the crc32 value for the file in the header.
				//.....................................................
				pfhdr.dwFileCrc32 ^= -1;

				// Determine if the file compressed ok or not.
				// If not, adjust some values.
				//............................................
				if (uliFileOut.QuadPart > uliFileIn.QuadPart)
				{
					pfhdr.LargestBitCode = 0;
					uliTotalCodes.QuadPart -= uliFileCodes.QuadPart;
					uliFileCodes.QuadPart = 0;
					pfhdr.uliCompressedFileSize.QuadPart = pfhdr.uliFileSize.QuadPart;
					uliTotalCodes.QuadPart += pfhdr.uliFileSize.QuadPart;
					uliOutCount.QuadPart += pfhdr.uliFileSize.QuadPart;
					uliOutCount.QuadPart -= uliFileOut.QuadPart;
					lpTransferFile = szDestination;
					hTransferFile = hDestination;
				}
				else
				{
					lpTransferFile = szTempFile;
					hTransferFile = hTempFile;
				}
				// Transfer the temporary file, or packed file as the case
				// may be, to the new compressed file. First rewind the file
				// to transfer.
				//.........................................................
				uli.QuadPart = 0;
				uli.QuadPart = SetMyFilePointer((LPTSTR)lpTransferFile,hTransferFile,
												 uli.QuadPart,FILE_BEGIN);
				if (uli.QuadPart == -1)
				{
					goto FreshEnd;
				}
				uli.QuadPart = pfhdr.uliCompressedFileSize.QuadPart;

				while(uli.QuadPart > 0)
				{
					if (uli.QuadPart > BUFFER_SIZE_IN)
					{
						dwBytesToRead = BUFFER_SIZE_IN;
						uli.QuadPart -= BUFFER_SIZE_IN;
					}
					else
					{
						dwBytesToRead = uli.LowPart;
						uli.QuadPart = 0;
					}
					bResult = ReadMyFile((LPTSTR)lpTransferFile,hTransferFile,
										  lpInBuffer,dwBytesToRead,&dwBytesRead,NULL);
					if (!bResult)
					{
						goto FreshEnd;
					}
					bResult = WriteMyFile((LPTSTR)&szBackUpFile,hBackUpFile,lpInBuffer,
										   dwBytesRead,&dwBytesWritten,NULL);
					if (!bResult)
					{
						goto FreshEnd;
					}
				}
			}
			else
			{
				// We have to zip the file.
				//.........................
				bResult = ZipMyFile((LPBYTE)&szBackUpFile,hBackUpFile,
								   (LPBYTE)&szDestination,hDestination);
				if (!bResult)
				{
					goto FreshEnd;
				}
			}
			// Calculate the header crc32 value for the file and write
			// the whole header to disk again.
			//...............................................
			CalculateHeaderCrc();
			uliHdr.QuadPart = SetMyFilePointer((LPTSTR)&szBackUpFile,hBackUpFile,
											    uliHdr.QuadPart,FILE_BEGIN);
			if (uliHdr.QuadPart == -1)
			{
				goto FreshEnd;
			}
			bResult = WriteMyFile((LPTSTR)&szBackUpFile,hBackUpFile,
								   &pfhdr,sizeof(PACKED_FILE_HEADER),&dwBytesWritten,NULL);
			if (!bResult)
			{
				goto FreshEnd;
			}
			if (bWeHaveLzw)
			{
				// Close and wipe the temporary packed file.
				//..........................................
				bResult = CloseMyHandle((LPTSTR)&szTempFile,hTempFile);
				if (!bResult)
				{
					goto FreshEnd;
				}
				hTempFile = 0;

				bResult = WipeMyFile((LPTSTR)&szTempFile,FALSE);
				if (bResult)
				{
					goto FreshEnd;
				}
			}
			// Close the file we just packed.
			//...............................
			bResult = CloseMyHandle((LPTSTR)&szDestination,hDestination);
			if (!bResult)
			{
				goto FreshEnd;
			}
			hDestination = 0;

			// If we have an icon open, delete it, but only if we have
			// more files to pack.
			//........................................................
			if (hIcon2 && iNumberOfFiles > 1)
			{
				DestroyIcon(hIcon2);
				hIcon2 = 0;
			}
			dwFilesFreshened++;
		}
		// Print running stats.
		//.....................
		StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szFreshResults,
					    dwFilesFreshened,pfidhdr.iFilesInVault);
		SetDlgItemText(hDialogModeLess,IDC_STATEMENT1,(LPCTSTR)&szOutBuffer);
		iNumberOfFiles--;
	}
	// Print final stats.
	//...................
	StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szFreshResults,
			  dwFilesFreshened,pfidhdr.iFilesInVault);
	SetDlgItemText(hDialogModeLess,IDC_STATEMENT1,(LPCTSTR)&szOutBuffer);

	// Set the position of the progress bar to 100% if we did not quit
	// or exit with an error
	//................................................................
	if (!bCancelOperation)
	{
		SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_SETPOS,(WPARAM)200,0);
	}
	// Make sure bCancelOperation is set to FALSE.
	//............................................
	bCancelOperation = FALSE;

	// Stop the avi clip.
	//...................
	if (bAviClipOK)
	{
		bAviClipOK = Animate_Stop(hAviClip);
	}
	// Change the cancel button to ok.
	//................................
	SetDlgItemText(hDialogModeLess,IDCANCEL,TEXT("&OK"));

	FlashMyIcon(TRUE);

	// Wait until we close the dialog box to exit.
	//............................................
	while(TRUE)
	{
		CheckForMessages();
		if (bCancelOperation == TRUE)
		{
			break;
		}
	}
	// Get the final file size of the packed file.
	//............................................
	uliFinalFileSize.QuadPart = 0;
	uliFinalFileSize.QuadPart = SetMyFilePointer((LPTSTR)&szBackUpFile, hBackUpFile,
												  uliFinalFileSize.QuadPart,FILE_END);
	if (uliFinalFileSize.QuadPart == -1)
	{
		goto FreshEnd;
	}
	bDiskError = FALSE;

	FreshEnd:

	FlashMyIcon(FALSE);

	Crc32Table(DELETE_TABLE);

	if (hIcon)
	{
		DestroyIcon(hIcon);
		hIcon = 0;
	}
	if (hIcon2)
	{
		DestroyIcon(hIcon2);
		hIcon2 = 0;
	}
	if (bAviClipOK)
	{
		Animate_Close(hAviClip);
	}
	if (hDialogModeLess)
	{
		DestroyWindow(hDialogModeLess);
	}
	if (lpCodeTable)
	{
		ZeroMemory(lpCodeTable,dwCodeTableSize);
		DeallocateMemory(lpCodeTable);
		lpCodeTable = 0;
	}
	if (lpHashTable)
	{
		ZeroMemory(lpHashTable,dwHashTableSize);
		DeallocateMemory(lpHashTable);
		lpHashTable = 0;
	}
	if (lpInBuffer)
	{
		ZeroMemory(lpInBuffer,BUFFER_SIZE_IN);
		DeallocateMemory(lpInBuffer);
		lpInBuffer = 0;
	}
	if (lpOutBuffer)
	{
		ZeroMemory(lpOutBuffer,BUFFER_SIZE_OUT);
		DeallocateMemory(lpOutBuffer);
		lpOutBuffer = 0;
	}
	if (hInputFile)
	{
		CloseMyHandle((LPTSTR)&szFileName,hInputFile);
		hInputFile = 0;
	}
	if (hBackUpFile)
	{
		CloseMyHandle((LPTSTR)&szBackUpFile,hBackUpFile);
		if (!bDiskError)
		{
			CopyFile((LPCTSTR)&szBackUpFile,(LPCTSTR)&szFileName,FALSE);
		}
		hBackUpFile = 0;
	}
	if (hTempFile)
	{
		CloseMyHandle((LPTSTR)&szTempFile,hTempFile);
		WipeMyFile((LPTSTR)&szTempFile,TRUE);
	}
	if (hDestination)
	{
		CloseMyHandle((LPTSTR)&szDestination,hDestination);
	}
	// Display the final stats if we did not have a disk error.
	//.........................................................
	if (!bDiskError)
	{
		CopyMemory(&szDestination,&szFileName,MAX_PATH);
		iResult = DialogBox(hInst,TEXT("PACKEDFILESTATUS"),hMainWindow,
						   (DLGPROC)PackedFileStatusProc);

		// See if we had a system error in creating the dialog box.
		//.........................................................
		if (iResult == -1)
		{
			ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		}
	}
	// Wipe the backup file.
	//......................
	if (!bDiskError)
	{
		WipeMyFile((LPTSTR)&szBackUpFile,TRUE);
	}
	bCancelOperation = FALSE;
	ChangeHelpTopic(dwOldHelpTopic);
	bProcessInProgress = FALSE;
}

// CALLBACK procedure for freshening a packed file.
//.................................................
LRESULT CALLBACK FreshenPackedFileProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			SetBoldFont(hDlg,IDC_STATEMENT1,0);

			// Open the avi clip and display its first frame
			// in the animation control.
			//..............................................
			hAviClip = GetDlgItem(hDlg,IDC_ANIMATE);
			bAviClipOK = Animate_Open(hAviClip,(LPSTR)iWhichAviClip);

			// Setup the range and step increment for the progress bar.
			//.........................................................
			SendMessage(GetDlgItem(hDlg,IDC_PROGRESS),PBM_SETRANGE32,0,(LPARAM)200);
			SendMessage(GetDlgItem(hDlg,IDC_PROGRESS),PBM_SETSTEP,(WPARAM)iStepIncrement,0);

			// Setup the name of the packed file to freshen.
			//..............................................
			SetDlgItemTextFmt(hDlg,IDC_FILE1,
							 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szFileName));

			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDCANCEL));
			return(FALSE);
		}

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				// Inform the procedure that we want to quit.
				//...........................................
				case IDCANCEL:
				{
					bCancelOperation = TRUE;
				}
				break;
			}
		}
		break;

		case WM_DESTROY:
		{
			if (hDlgFont)
			{
				DeleteObject(hDlgFont);
				hDlgFont = 0;
			}
			hDialogModeLess = NULL;
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Build a central directory of the files in a packed file.
// Entry: Handle in hInputfile, name in szFileName, file
// header in pfidhdr. File pointer pointing to first file
// header.
//.........................................................
BOOL BuildPackedFileCentralDir(LPBYTE lpPackedFile, HANDLE hPackedFile)
{
	ULARGE_INTEGER		uli;
	LPPACKED_FILE_DIR	lpDir;
	LPBYTE				lpFileName;
	BOOL				bResult = FALSE;
	int					iTotalFiles;
	DWORD				dwBytesRead;
	DWORD				dwHeaderSize;

	dwHeaderSize = sizeof(PACKED_FILE_DIR);

	iTotalFiles = pfidhdr.iFilesInVault;

	// Allocate memory for the central directory.
	//...........................................
	lppfd = AllocateMemory(iTotalFiles * sizeof(PACKED_FILE_DIR));
	lpDir = lppfd;
	if (!lppfd)
	{
		goto BuildEnd;
	}
	while(iTotalFiles > 0)
	{
		bResult = ReadMyFile((LPTSTR)lpPackedFile,hPackedFile,
							 lpDir,sizeof(PACKED_FILE_HEADER),&dwBytesRead,NULL);
		if (!bResult)
		{
			goto BuildEnd;
		}
		// Setup the address for reading the file name into.
		//..................................................
		lpFileName = (LPBYTE)lpDir;
		lpFileName += sizeof(PACKED_FILE_HEADER);

		bResult = ReadMyFile((LPTSTR)lpPackedFile,hPackedFile,
							  lpFileName,lpDir->pfh.wLengthOfFileName,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto BuildEnd;
		}
		// Get past the compressed data to the next file header.
		//......................................................
		uli.QuadPart = SetMyFilePointer((LPTSTR)lpPackedFile,hPackedFile,
										 lpDir->pfh.uliCompressedFileSize.QuadPart,
										 FILE_CURRENT);
		if (uli.QuadPart == -1)
		{
			bResult = FALSE;
			goto BuildEnd;
		}
		// Check the file header to make sure it is ok.
		//.............................................
		CopyMemory(&pfhdr,lpDir,sizeof(PACKED_FILE_HEADER));
		bResult = CheckHeaderCrc();
		if (!bResult)
		{
			goto BuildEnd;
		}
		// Setup the next entry in the central directory.
		//...............................................
		__asm
		{
			mov		eax,dwHeaderSize
			add		lpDir,eax
		}
		iTotalFiles--;
	}
	BuildEnd:

	return(bResult);
}
